"use strict";var e,t,i,a=require("@csstools/css-parser-algorithms"),r=require("@csstools/css-tokenizer");exports.NodeType=void 0,(e=exports.NodeType||(exports.NodeType={})).CustomMedia="custom-media",e.GeneralEnclosed="general-enclosed",e.MediaAnd="media-and",e.MediaCondition="media-condition",e.MediaConditionListWithAnd="media-condition-list-and",e.MediaConditionListWithOr="media-condition-list-or",e.MediaFeature="media-feature",e.MediaFeatureBoolean="mf-boolean",e.MediaFeatureName="mf-name",e.MediaFeaturePlain="mf-plain",e.MediaFeatureRangeNameValue="mf-range-name-value",e.MediaFeatureRangeValueName="mf-range-value-name",e.MediaFeatureRangeValueNameValue="mf-range-value-name-value",e.MediaFeatureValue="mf-value",e.MediaInParens="media-in-parens",e.MediaNot="media-not",e.MediaOr="media-or",e.MediaQueryWithType="media-query-with-type",e.MediaQueryWithoutType="media-query-without-type",e.MediaQueryInvalid="media-query-invalid";class MediaCondition{type=exports.NodeType.MediaCondition;media;constructor(e){this.media=e}tokens(){return this.media.tokens()}toString(){return this.media.toString()}indexOf(e){return e===this.media?"media":-1}at(e){if("media"===e)return this.media}walk(e){return!1!==e({node:this.media,parent:this},"media")&&this.media.walk(e)}toJSON(){return{type:this.type,media:this.media.toJSON()}}isMediaCondition(){return MediaCondition.isMediaCondition(this)}static isMediaCondition(e){return!!e&&(e instanceof MediaCondition&&e.type===exports.NodeType.MediaCondition)}}class MediaInParens{type=exports.NodeType.MediaInParens;media;before;after;constructor(e,t=[],i=[]){this.media=e,this.before=t,this.after=i}tokens(){return[...this.before,...this.media.tokens(),...this.after]}toString(){return r.stringify(...this.before)+this.media.toString()+r.stringify(...this.after)}indexOf(e){return e===this.media?"media":-1}at(e){if("media"===e)return this.media}walk(e){return!1!==e({node:this.media,parent:this},"media")&&("walk"in this.media?this.media.walk(e):void 0)}toJSON(){return{type:this.type,media:this.media.toJSON(),before:this.before,after:this.after}}isMediaInParens(){return MediaInParens.isMediaInParens(this)}static isMediaInParens(e){return!!e&&(e instanceof MediaInParens&&e.type===exports.NodeType.MediaInParens)}}class MediaQueryWithType{type=exports.NodeType.MediaQueryWithType;modifier;mediaType;and;media=null;constructor(e,t,i,a){this.modifier=e,this.mediaType=t,i&&a&&(this.and=i,this.media=a)}getModifier(){if(!this.modifier.length)return"";for(let e=0;e<this.modifier.length;e++){const t=this.modifier[e];if(t[0]===r.TokenType.Ident)return t[4].value}return""}negateQuery(){const e=new MediaQueryWithType([...this.modifier],[...this.mediaType],this.and,this.media);if(0===e.modifier.length)return e.modifier=[[r.TokenType.Ident,"not",-1,-1,{value:"not"}],[r.TokenType.Whitespace," ",-1,-1,void 0]],e;for(let t=0;t<e.modifier.length;t++){const i=e.modifier[t];if(i[0]===r.TokenType.Ident&&"not"===i[4].value.toLowerCase()){e.modifier.splice(t,1);break}if(i[0]===r.TokenType.Ident&&"only"===i[4].value.toLowerCase()){e.modifier[t][1]="not",e.modifier[t][4].value="not";break}}return e}getMediaType(){if(!this.mediaType.length)return"";for(let e=0;e<this.mediaType.length;e++){const t=this.mediaType[e];if(t[0]===r.TokenType.Ident)return t[4].value}return""}tokens(){return this.and&&this.media?[...this.modifier,...this.mediaType,...this.and,...this.media.tokens()]:[...this.modifier,...this.mediaType]}toString(){return this.and&&this.media?r.stringify(...this.modifier)+r.stringify(...this.mediaType)+r.stringify(...this.and)+this.media.toString():r.stringify(...this.modifier)+r.stringify(...this.mediaType)}indexOf(e){return e===this.media?"media":-1}at(e){if("media"===e)return this.media}walk(e){return!1!==e({node:this.media,parent:this},"media")&&(this.media?this.media.walk(e):void 0)}toJSON(){return{type:this.type,string:this.toString(),modifier:this.modifier,mediaType:this.mediaType,and:this.and,media:this.media}}isMediaQueryWithType(){return MediaQueryWithType.isMediaQueryWithType(this)}static isMediaQueryWithType(e){return!!e&&(e instanceof MediaQueryWithType&&e.type===exports.NodeType.MediaQueryWithType)}}class MediaQueryWithoutType{type=exports.NodeType.MediaQueryWithoutType;media;constructor(e){this.media=e}negateQuery(){let e=this.media;if(e.media.type===exports.NodeType.MediaNot)return new MediaQueryWithoutType(new MediaCondition(e.media.media));e.media.type===exports.NodeType.MediaConditionListWithOr&&(e=new MediaCondition(new MediaInParens(e,[[r.TokenType.Whitespace," ",0,0,void 0],[r.TokenType.OpenParen,"(",0,0,void 0]],[[r.TokenType.CloseParen,")",0,0,void 0]])));return new MediaQueryWithType([[r.TokenType.Ident,"not",0,0,{value:"not"}],[r.TokenType.Whitespace," ",0,0,void 0]],[[r.TokenType.Ident,"all",0,0,{value:"all"}],[r.TokenType.Whitespace," ",0,0,void 0]],[[r.TokenType.Ident,"and",0,0,{value:"and"}]],e)}tokens(){return this.media.tokens()}toString(){return this.media.toString()}indexOf(e){return e===this.media?"media":-1}at(e){if("media"===e)return this.media}walk(e){return!1!==e({node:this.media,parent:this},"media")&&this.media.walk(e)}toJSON(){return{type:this.type,string:this.toString(),media:this.media}}isMediaQueryWithoutType(){return MediaQueryWithoutType.isMediaQueryWithoutType(this)}static isMediaQueryWithoutType(e){return!!e&&(e instanceof MediaQueryWithoutType&&e.type===exports.NodeType.MediaQueryWithoutType)}}class MediaQueryInvalid{type=exports.NodeType.MediaQueryInvalid;media;constructor(e){this.media=e}negateQuery(){return new MediaQueryInvalid(this.media)}tokens(){return this.media.flatMap((e=>e.tokens()))}toString(){return this.media.map((e=>e.toString())).join("")}walk(e){let t=!1;if(this.media.forEach(((i,a)=>{t||(!1!==e({node:i,parent:this},a)?"walk"in i&&!1===i.walk(e)&&(t=!0):t=!0)})),t)return!1}toJSON(){return{type:this.type,string:this.toString(),media:this.media}}isMediaQueryInvalid(){return MediaQueryInvalid.isMediaQueryInvalid(this)}static isMediaQueryInvalid(e){return!!e&&(e instanceof MediaQueryInvalid&&e.type===exports.NodeType.MediaQueryInvalid)}}class GeneralEnclosed{type=exports.NodeType.GeneralEnclosed;value;constructor(e){this.value=e}tokens(){return this.value.tokens()}toString(){return this.value.toString()}indexOf(e){return e===this.value?"value":-1}at(e){if("value"===e)return this.value}walk(e){return!1!==e({node:this.value,parent:this},"value")&&("walk"in this.value?this.value.walk(e):void 0)}toJSON(){return{type:this.type,tokens:this.tokens()}}isGeneralEnclosed(){return GeneralEnclosed.isGeneralEnclosed(this)}static isGeneralEnclosed(e){return!!e&&(e instanceof GeneralEnclosed&&e.type===exports.NodeType.GeneralEnclosed)}}class MediaAnd{type=exports.NodeType.MediaAnd;modifier;media;constructor(e,t){this.modifier=e,this.media=t}tokens(){return[...this.modifier,...this.media.tokens()]}toString(){return r.stringify(...this.modifier)+this.media.toString()}indexOf(e){return e===this.media?"media":-1}at(e){if("media"===e)return this.media}walk(e){return!1!==e({node:this.media,parent:this},"media")&&this.media.walk(e)}toJSON(){return{type:this.type,modifier:this.modifier,media:this.media.toJSON()}}isMediaAnd(){return MediaAnd.isMediaAnd(this)}static isMediaAnd(e){return!!e&&(e instanceof MediaAnd&&e.type===exports.NodeType.MediaAnd)}}class MediaConditionListWithAnd{type=exports.NodeType.MediaConditionListWithAnd;leading;list;before;after;constructor(e,t,i=[],a=[]){this.leading=e,this.list=t,this.before=i,this.after=a}tokens(){return[...this.before,...this.leading.tokens(),...this.list.flatMap((e=>e.tokens())),...this.after]}toString(){return r.stringify(...this.before)+this.leading.toString()+this.list.map((e=>e.toString())).join("")+r.stringify(...this.after)}indexOf(e){return e===this.leading?"leading":"media-and"===e.type?this.list.indexOf(e):-1}at(e){return"leading"===e?this.leading:"number"==typeof e?(e<0&&(e=this.list.length+e),this.list[e]):void 0}walk(e){if(!1===e({node:this.leading,parent:this},"leading"))return!1;if("walk"in this.leading&&!1===this.leading.walk(e))return!1;let t=!1;return this.list.forEach(((i,a)=>{t||(!1!==e({node:i,parent:this},a)?"walk"in i&&!1===i.walk(e)&&(t=!0):t=!0)})),!t&&void 0}toJSON(){return{type:this.type,leading:this.leading.toJSON(),list:this.list.map((e=>e.toJSON())),before:this.before,after:this.after}}isMediaConditionListWithAnd(){return MediaConditionListWithAnd.isMediaConditionListWithAnd(this)}static isMediaConditionListWithAnd(e){return!!e&&(e instanceof MediaConditionListWithAnd&&e.type===exports.NodeType.MediaConditionListWithAnd)}}class MediaConditionListWithOr{type=exports.NodeType.MediaConditionListWithOr;leading;list;before;after;constructor(e,t,i=[],a=[]){this.leading=e,this.list=t,this.before=i,this.after=a}tokens(){return[...this.before,...this.leading.tokens(),...this.list.flatMap((e=>e.tokens())),...this.after]}toString(){return r.stringify(...this.before)+this.leading.toString()+this.list.map((e=>e.toString())).join("")+r.stringify(...this.after)}indexOf(e){return e===this.leading?"leading":"media-or"===e.type?this.list.indexOf(e):-1}at(e){return"leading"===e?this.leading:"number"==typeof e?(e<0&&(e=this.list.length+e),this.list[e]):void 0}walk(e){if(!1===e({node:this.leading,parent:this},"leading"))return!1;if("walk"in this.leading&&!1===this.leading.walk(e))return!1;let t=!1;return this.list.forEach(((i,a)=>{t||(!1!==e({node:i,parent:this},a)?"walk"in i&&!1===i.walk(e)&&(t=!0):t=!0)})),!t&&void 0}toJSON(){return{type:this.type,leading:this.leading.toJSON(),list:this.list.map((e=>e.toJSON())),before:this.before,after:this.after}}isMediaConditionListWithOr(){return MediaConditionListWithOr.isMediaConditionListWithOr(this)}static isMediaConditionListWithOr(e){return!!e&&(e instanceof MediaConditionListWithOr&&e.type===exports.NodeType.MediaConditionListWithOr)}}function isNumber(e){return e.type===a.ComponentValueType.Token&&e.value[0]===r.TokenType.Number||e.type===a.ComponentValueType.Function&&"calc"===e.name[4].value}function isDimension(e){return e.type===a.ComponentValueType.Token&&e.value[0]===r.TokenType.Dimension}function isIdent(e){return e.type===a.ComponentValueType.Token&&e.value[0]===r.TokenType.Ident}class MediaFeatureName{type=exports.NodeType.MediaFeatureName;name;before;after;constructor(e,t=[],i=[]){this.name=e,this.before=t,this.after=i}getName(){return this.name.value[4].value}getNameToken(){return this.name.value}tokens(){return[...this.before,...this.name.tokens(),...this.after]}toString(){return r.stringify(...this.before)+this.name.toString()+r.stringify(...this.after)}indexOf(e){return e===this.name?"name":-1}at(e){if("name"===e)return this.name}toJSON(){return{type:this.type,name:this.getName(),tokens:this.tokens()}}isMediaFeatureName(){return MediaFeatureName.isMediaFeatureName(this)}static isMediaFeatureName(e){return!!e&&(e instanceof MediaFeatureName&&e.type===exports.NodeType.MediaFeatureName)}}function parseMediaFeatureName(e){let t=-1;for(let i=0;i<e.length;i++){const r=e[i];if(r.type!==a.ComponentValueType.Whitespace&&r.type!==a.ComponentValueType.Comment){if(!isIdent(r))return!1;if(-1!==t)return!1;t=i}}return-1!==t&&new MediaFeatureName(e[t],e.slice(0,t).flatMap((e=>e.tokens())),e.slice(t+1).flatMap((e=>e.tokens())))}class MediaFeatureBoolean{type=exports.NodeType.MediaFeatureBoolean;name;constructor(e){this.name=e}getName(){return this.name.getName()}getNameToken(){return this.name.getNameToken()}tokens(){return this.name.tokens()}toString(){return this.name.toString()}indexOf(e){return e===this.name?"name":-1}at(e){if("name"===e)return this.name}toJSON(){return{type:this.type,name:this.name.toJSON(),tokens:this.tokens()}}isMediaFeatureBoolean(){return MediaFeatureBoolean.isMediaFeatureBoolean(this)}static isMediaFeatureBoolean(e){return!!e&&(e instanceof MediaFeatureBoolean&&e.type===exports.NodeType.MediaFeatureBoolean)}}function parseMediaFeatureBoolean(e){const t=parseMediaFeatureName(e);return!1===t?t:new MediaFeatureBoolean(t)}class MediaFeatureValue{type=exports.NodeType.MediaFeatureValue;value;before;after;constructor(e,t=[],i=[]){Array.isArray(e)&&1===e.length?this.value=e[0]:this.value=e,this.before=t,this.after=i}tokens(){return Array.isArray(this.value)?[...this.before,...this.value.flatMap((e=>e.tokens())),...this.after]:[...this.before,...this.value.tokens(),...this.after]}toString(){return Array.isArray(this.value)?r.stringify(...this.before)+this.value.map((e=>e.toString())).join("")+r.stringify(...this.after):r.stringify(...this.before)+this.value.toString()+r.stringify(...this.after)}indexOf(e){return e===this.value?"value":-1}at(e){if("value"===e)return this.value}walk(e){return!1!==e({node:this.value,parent:this},"value")&&("walk"in this.value?this.value.walk(e):void 0)}toJSON(){return Array.isArray(this.value)?{type:this.type,value:this.value.map((e=>e.toJSON())),tokens:this.tokens()}:{type:this.type,value:this.value.toJSON(),tokens:this.tokens()}}isMediaFeatureValue(){return MediaFeatureValue.isMediaFeatureValue(this)}static isMediaFeatureValue(e){return!!e&&(e instanceof MediaFeatureValue&&e.type===exports.NodeType.MediaFeatureValue)}}function parseMediaFeatureValue(e){let t=-1,i=-1;for(let r=0;r<e.length;r++){const n=e[r];if(n.type!==a.ComponentValueType.Whitespace&&n.type!==a.ComponentValueType.Comment){if(-1!==t)return!1;if(isNumber(n)){const a=matchesRatioExactly(e.slice(r));if(-1!==a){t=a[0]+r,i=a[1]+r,r+=a[1]-a[0];continue}t=r,i=r}else if(isDimension(n))t=r,i=r;else{if(!isIdent(n))return!1;t=r,i=r}}}return-1!==t&&new MediaFeatureValue(e.slice(t,i+1),e.slice(0,t).flatMap((e=>e.tokens())),e.slice(i+1).flatMap((e=>e.tokens())))}function matchesRatioExactly(e){let t=-1,i=-1;const a=matchesRatio(e);if(-1===a)return-1;t=a[0],i=a[1];for(let t=i+1;t<e.length;t++){const i=e[t];if("whitespace"!==i.type&&"comment"!==i.type)return-1}return[t,i]}function matchesRatio(e){let t=-1,i=-1;for(let a=0;a<e.length;a++){const n=e[a];if("whitespace"!==n.type&&"comment"!==n.type){if("token"===n.type){const e=n.value;if(e[0]===r.TokenType.Delim&&"/"===e[4].value){if(-1===t)return-1;if(-1!==i)return-1;i=a;continue}}if(!isNumber(n))return-1;if(-1!==i)return[t,a];if(-1!==t)return-1;t=a}}return-1}class MediaFeaturePlain{type=exports.NodeType.MediaFeaturePlain;name;colon;value;constructor(e,t,i){this.name=e,this.colon=t,this.value=i}getName(){return this.name.getName()}getNameToken(){return this.name.getNameToken()}tokens(){return[...this.name.tokens(),this.colon,...this.value.tokens()]}toString(){return this.name.toString()+r.stringify(this.colon)+this.value.toString()}indexOf(e){return e===this.name?"name":e===this.value?"value":-1}at(e){return"name"===e?this.name:"value"===e?this.value:void 0}walk(e){return!1!==e({node:this.value,parent:this},"value")&&this.value.walk(e)}toJSON(){return{type:this.type,name:this.name.toJSON(),value:this.value.toJSON(),tokens:this.tokens()}}isMediaFeaturePlain(){return MediaFeaturePlain.isMediaFeaturePlain(this)}static isMediaFeaturePlain(e){return!!e&&(e instanceof MediaFeaturePlain&&e.type===exports.NodeType.MediaFeaturePlain)}}function parseMediaFeaturePlain(e){let t=[],i=[],n=null;for(let o=0;o<e.length;o++){const s=e[o];if(s.type===a.ComponentValueType.Token){const a=s.value;if(a[0]===r.TokenType.Colon){t=e.slice(0,o),i=e.slice(o+1),n=a;break}}}if(!t.length||!i.length)return!1;const o=parseMediaFeatureName(t);if(!1===o)return!1;const s=parseMediaFeatureValue(i);return!1!==s&&new MediaFeaturePlain(o,n,s)}function matchesComparison(e){let t=-1;for(let i=0;i<e.length;i++){const n=e[i];if(n.type===a.ComponentValueType.Token){const e=n.value;if(e[0]===r.TokenType.Delim){if(e[4].value===exports.MediaFeatureEQ.EQ){if(-1!==t)return[t,i];t=i;continue}if(e[4].value===exports.MediaFeatureLT.LT){t=i;continue}if(e[4].value===exports.MediaFeatureGT.GT){t=i;continue}}}break}return-1!==t&&[t,t]}function comparisonFromTokens(e){if(0===e.length||e.length>2)return!1;if(e[0][0]!==r.TokenType.Delim)return!1;if(1===e.length)switch(e[0][4].value){case exports.MediaFeatureEQ.EQ:return exports.MediaFeatureEQ.EQ;case exports.MediaFeatureLT.LT:return exports.MediaFeatureLT.LT;case exports.MediaFeatureGT.GT:return exports.MediaFeatureGT.GT;default:return!1}if(e[1][0]!==r.TokenType.Delim)return!1;if(e[1][4].value!==exports.MediaFeatureEQ.EQ)return!1;switch(e[0][4].value){case exports.MediaFeatureLT.LT:return exports.MediaFeatureLT.LT_OR_EQ;case exports.MediaFeatureGT.GT:return exports.MediaFeatureGT.GT_OR_EQ;default:return!1}}exports.MediaFeatureLT=void 0,(t=exports.MediaFeatureLT||(exports.MediaFeatureLT={})).LT="<",t.LT_OR_EQ="<=",exports.MediaFeatureGT=void 0,(i=exports.MediaFeatureGT||(exports.MediaFeatureGT={})).GT=">",i.GT_OR_EQ=">=",exports.MediaFeatureEQ=void 0,(exports.MediaFeatureEQ||(exports.MediaFeatureEQ={})).EQ="=";class MediaFeatureRangeNameValue{type=exports.NodeType.MediaFeatureRangeNameValue;name;operator;value;constructor(e,t,i){this.name=e,this.operator=t,this.value=i}operatorKind(){return comparisonFromTokens(this.operator)}getName(){return this.name.getName()}getNameToken(){return this.name.getNameToken()}tokens(){return[...this.name.tokens(),...this.operator,...this.value.tokens()]}toString(){return this.name.toString()+r.stringify(...this.operator)+this.value.toString()}indexOf(e){return e===this.name?"name":e===this.value?"value":-1}at(e){return"name"===e?this.name:"value"===e?this.value:void 0}walk(e){return!1!==e({node:this.value,parent:this},"value")&&("walk"in this.value?this.value.walk(e):void 0)}toJSON(){return{type:this.type,name:this.name.toJSON(),value:this.value.toJSON(),tokens:this.tokens()}}isMediaFeatureRangeNameValue(){return MediaFeatureRangeNameValue.isMediaFeatureRangeNameValue(this)}static isMediaFeatureRangeNameValue(e){return!!e&&(e instanceof MediaFeatureRangeNameValue&&e.type===exports.NodeType.MediaFeatureRangeNameValue)}}class MediaFeatureRangeValueName{type=exports.NodeType.MediaFeatureRangeValueName;name;operator;value;constructor(e,t,i){this.name=e,this.operator=t,this.value=i}operatorKind(){return comparisonFromTokens(this.operator)}getName(){return this.name.getName()}getNameToken(){return this.name.getNameToken()}tokens(){return[...this.value.tokens(),...this.operator,...this.name.tokens()]}toString(){return this.value.toString()+r.stringify(...this.operator)+this.name.toString()}indexOf(e){return e===this.name?"name":e===this.value?"value":-1}at(e){return"name"===e?this.name:"value"===e?this.value:void 0}walk(e){return!1!==e({node:this.value,parent:this},"value")&&("walk"in this.value?this.value.walk(e):void 0)}toJSON(){return{type:this.type,name:this.name.toJSON(),value:this.value.toJSON(),tokens:this.tokens()}}isMediaFeatureRangeValueName(){return MediaFeatureRangeValueName.isMediaFeatureRangeValueName(this)}static isMediaFeatureRangeValueName(e){return!!e&&(e instanceof MediaFeatureRangeValueName&&e.type===exports.NodeType.MediaFeatureRangeValueName)}}class MediaFeatureRangeValueNameValue{type=exports.NodeType.MediaFeatureRangeValueNameValue;name;valueOne;valueOneOperator;valueTwo;valueTwoOperator;constructor(e,t,i,a,r){this.name=e,this.valueOne=t,this.valueOneOperator=i,this.valueTwo=a,this.valueTwoOperator=r}valueOneOperatorKind(){return comparisonFromTokens(this.valueOneOperator)}valueTwoOperatorKind(){return comparisonFromTokens(this.valueTwoOperator)}getName(){return this.name.getName()}getNameToken(){return this.name.getNameToken()}tokens(){return[...this.valueOne.tokens(),...this.valueOneOperator,...this.name.tokens(),...this.valueTwoOperator,...this.valueTwo.tokens()]}toString(){return this.valueOne.toString()+r.stringify(...this.valueOneOperator)+this.name.toString()+r.stringify(...this.valueTwoOperator)+this.valueTwo.toString()}indexOf(e){return e===this.name?"name":e===this.valueOne?"valueOne":e===this.valueTwo?"valueTwo":-1}at(e){return"name"===e?this.name:"valueOne"===e?this.valueOne:"valueTwo"===e?this.valueTwo:void 0}walk(e){return!1!==e({node:this.valueOne,parent:this},"valueOne")&&((!("walk"in this.valueOne)||!1!==this.valueOne.walk(e))&&(!1!==e({node:this.valueTwo,parent:this},"valueTwo")&&((!("walk"in this.valueTwo)||!1!==this.valueTwo.walk(e))&&void 0)))}toJSON(){return{type:this.type,name:this.name.toJSON(),valueOne:this.valueOne.toJSON(),valueTwo:this.valueTwo.toJSON(),tokens:this.tokens()}}isMediaFeatureRangeValueNameValue(){return MediaFeatureRangeValueNameValue.isMediaFeatureRangeValueNameValue(this)}static isMediaFeatureRangeValueNameValue(e){return!!e&&(e instanceof MediaFeatureRangeValueNameValue&&e.type===exports.NodeType.MediaFeatureRangeValueNameValue)}}function parseMediaFeatureRange(e){let t=!1,i=!1;for(let n=0;n<e.length;n++){const o=e[n];if(o.type===a.ComponentValueType.Token){if(o.value[0]===r.TokenType.Delim){const a=matchesComparison(e.slice(n));if(!1!==a){if(!1!==t){i=[a[0]+n,a[1]+n];break}t=[a[0]+n,a[1]+n],n+=a[1]}}}}if(!1===t)return!1;const o=[e[t[0]].value];if(t[0]!==t[1]&&o.push(e[t[1]].value),!1===i){const i=e.slice(0,t[0]),a=e.slice(t[1]+1),r=parseMediaFeatureName(i),s=parseMediaFeatureName(a);if(!r&&!s)return!1;if(r&&!s||r&&n.has(r.getName().toLowerCase())){const e=parseMediaFeatureValue(a);return!!e&&new MediaFeatureRangeNameValue(r,o,e)}if(!r&&s||s&&n.has(s.getName().toLowerCase())){const e=parseMediaFeatureValue(i);return!!e&&new MediaFeatureRangeValueName(s,o,e)}return!1}const s=[e[i[0]].value];i[0]!==i[1]&&s.push(e[i[1]].value);const u=e.slice(0,t[0]),d=e.slice(t[1]+1,i[0]),l=e.slice(i[1]+1),p=parseMediaFeatureValue(u),h=parseMediaFeatureName(d),m=parseMediaFeatureValue(l);if(!p||!h||!m)return!1;{const e=comparisonFromTokens(o);if(!1===e||e===exports.MediaFeatureEQ.EQ)return!1;const t=comparisonFromTokens(s);if(!1===t||t===exports.MediaFeatureEQ.EQ)return!1;if(!(e!==exports.MediaFeatureLT.LT&&e!==exports.MediaFeatureLT.LT_OR_EQ||t!==exports.MediaFeatureGT.GT&&t!==exports.MediaFeatureGT.GT_OR_EQ))return!1;if(!(e!==exports.MediaFeatureGT.GT&&e!==exports.MediaFeatureGT.GT_OR_EQ||t!==exports.MediaFeatureLT.LT&&t!==exports.MediaFeatureLT.LT_OR_EQ))return!1}return new MediaFeatureRangeValueNameValue(h,p,o,m,s)}const n=new Set(["any-hover","any-pointer","aspect-ratio","color","color-gamut","color-index","device-aspect-ratio","device-height","device-width","display-mode","dynamic-range","environment-blending","forced-colors","grid","height","horizontal-viewport-segments","hover","inverted-colors","monochrome","nav-controls","orientation","overflow-block","overflow-inline","pointer","prefers-color-scheme","prefers-contrast","prefers-reduced-data","prefers-reduced-motion","prefers-reduced-transparency","resolution","scan","scripting","update","vertical-viewport-segments","video-color-gamut","video-dynamic-range","width"]);class MediaFeature{type=exports.NodeType.MediaFeature;feature;before;after;constructor(e,t=[],i=[]){this.feature=e,this.before=t,this.after=i}getName(){return this.feature.getName()}getNameToken(){return this.feature.getNameToken()}tokens(){return[...this.before,...this.feature.tokens(),...this.after]}toString(){return r.stringify(...this.before)+this.feature.toString()+r.stringify(...this.after)}indexOf(e){return e===this.feature?"feature":-1}at(e){if("feature"===e)return this.feature}walk(e){return!1!==e({node:this.feature,parent:this},"feature")&&("walk"in this.feature?this.feature.walk(e):void 0)}toJSON(){return{type:this.type,feature:this.feature.toJSON(),before:this.before,after:this.after}}isMediaFeature(){return MediaFeature.isMediaFeature(this)}static isMediaFeature(e){return!!e&&(e instanceof MediaFeature&&e.type===exports.NodeType.MediaFeature)}}function parseMediaFeature(e,t=[],i=[]){if(e.startToken[0]!==r.TokenType.OpenParen)return!1;const a=parseMediaFeatureBoolean(e.value);if(!1!==a)return new MediaFeature(a,t,i);const n=parseMediaFeaturePlain(e.value);if(!1!==n)return new MediaFeature(n,t,i);const o=parseMediaFeatureRange(e.value);return!1!==o&&new MediaFeature(o,t,i)}class MediaNot{type=exports.NodeType.MediaNot;modifier;media;constructor(e,t){this.modifier=e,this.media=t}tokens(){return[...this.modifier,...this.media.tokens()]}toString(){return r.stringify(...this.modifier)+this.media.toString()}indexOf(e){return e===this.media?"media":-1}at(e){if("media"===e)return this.media}walk(e){return!1!==e({node:this.media,parent:this},"media")&&this.media.walk(e)}toJSON(){return{type:this.type,modifier:this.modifier,media:this.media.toJSON()}}isMediaNot(){return MediaNot.isMediaNot(this)}static isMediaNot(e){return!!e&&(e instanceof MediaNot&&e.type===exports.NodeType.MediaNot)}}class MediaOr{type=exports.NodeType.MediaOr;modifier;media;constructor(e,t){this.modifier=e,this.media=t}tokens(){return[...this.modifier,...this.media.tokens()]}toString(){return r.stringify(...this.modifier)+this.media.toString()}indexOf(e){return e===this.media?"media":-1}at(e){if("media"===e)return this.media}walk(e){return!1!==e({node:this.media,parent:this},"media")&&this.media.walk(e)}toJSON(){return{type:this.type,modifier:this.modifier,media:this.media.toJSON()}}isMediaOr(){return MediaOr.isMediaOr(this)}static isMediaOr(e){return!!e&&(e instanceof MediaOr&&e.type===exports.NodeType.MediaOr)}}var o,s;function modifierFromToken(e){if(e[0]!==r.TokenType.Ident)return!1;switch(e[4].value.toLowerCase()){case exports.MediaQueryModifier.Not:return exports.MediaQueryModifier.Not;case exports.MediaQueryModifier.Only:return exports.MediaQueryModifier.Only;default:return!1}}function parseMediaQuery(e){{const t=parseMediaCondition(e);if(!1!==t)return new MediaQueryWithoutType(t)}{let t=-1,i=-1,n=-1;for(let o=0;o<e.length;o++){const s=e[o];if(!a.isWhitespaceNode(s)&&!a.isCommentNode(s)){if(a.isTokenNode(s)){const a=s.value;if(-1===t&&a[0]===r.TokenType.Ident&&modifierFromToken(a)){t=o;continue}if(-1===i&&a[0]===r.TokenType.Ident&&!modifierFromToken(a)){i=o;continue}if(-1===n&&a[0]===r.TokenType.Ident&&"and"===a[4].value.toLowerCase()){n=o;if(!1===parseMediaConditionWithoutOr(e.slice(o+1)))return!1;break}return!1}return!1}}let o=[],s=[];-1!==t?(o=e.slice(0,t+1).flatMap((e=>e.tokens())),-1!==i&&(s=e.slice(t+1,i+1).flatMap((e=>e.tokens())))):-1!==i&&(s=e.slice(0,i+1).flatMap((e=>e.tokens())));const u=parseMediaConditionWithoutOr(e.slice(Math.max(t,i,n)+1));return!1===u?new MediaQueryWithType(o,[...s,...e.slice(i+1).flatMap((e=>e.tokens()))]):new MediaQueryWithType(o,s,e.slice(i+1,n+1).flatMap((e=>e.tokens())),u)}}function parseMediaConditionListWithOr(e){let t=!1;const i=[];let r=-1,n=-1;for(let o=0;o<e.length;o++){if(t){const t=parseMediaOr(e.slice(o));if(!1!==t){o+=t.advance,i.push(t.node),n=o;continue}}const s=e[o];if(s.type!==a.ComponentValueType.Whitespace&&s.type!==a.ComponentValueType.Comment){if(t)return!1;if(!1!==t||!a.isSimpleBlockNode(s))return!1;if(s.normalize(),t=parseMediaInParensFromSimpleBlock(s),!1===t)return!1;r=o}}return!(!t||!i.length)&&new MediaConditionListWithOr(t,i,e.slice(0,r).flatMap((e=>e.tokens())),e.slice(n+1).flatMap((e=>e.tokens())))}function parseMediaConditionListWithAnd(e){let t=!1;const i=[];let r=-1,n=-1;for(let o=0;o<e.length;o++){if(t){const t=parseMediaAnd(e.slice(o));if(!1!==t){o+=t.advance,i.push(t.node),n=o;continue}}const s=e[o];if(s.type!==a.ComponentValueType.Whitespace&&s.type!==a.ComponentValueType.Comment){if(t)return!1;if(!1!==t||!a.isSimpleBlockNode(s))return!1;if(s.normalize(),t=parseMediaInParensFromSimpleBlock(s),!1===t)return!1;r=o}}return!(!t||!i.length)&&new MediaConditionListWithAnd(t,i,e.slice(0,r).flatMap((e=>e.tokens())),e.slice(n+1).flatMap((e=>e.tokens())))}function parseMediaCondition(e){const t=parseMediaNot(e);if(!1!==t)return new MediaCondition(t);const i=parseMediaConditionListWithAnd(e);if(!1!==i)return new MediaCondition(i);const a=parseMediaConditionListWithOr(e);if(!1!==a)return new MediaCondition(a);const r=parseMediaInParens(e);return!1!==r&&new MediaCondition(r)}function parseMediaConditionWithoutOr(e){const t=parseMediaNot(e);if(!1!==t)return new MediaCondition(t);const i=parseMediaConditionListWithAnd(e);if(!1!==i)return new MediaCondition(i);const a=parseMediaInParens(e);return!1!==a&&new MediaCondition(a)}function parseMediaInParens(e){let t=-1;for(let i=0;i<e.length;i++){const r=e[i];if(r.type!==a.ComponentValueType.Whitespace&&r.type!==a.ComponentValueType.Comment){if(!a.isSimpleBlockNode(r))return!1;if(-1!==t)return!1;t=i}}if(-1===t)return!1;const i=e[t];if(i.startToken[0]!==r.TokenType.OpenParen)return!1;i.normalize();const n=[...e.slice(0,t).flatMap((e=>e.tokens())),i.startToken],o=[i.endToken,...e.slice(t+1).flatMap((e=>e.tokens()))],s=parseMediaFeature(i,n,o);if(!1!==s)return new MediaInParens(s);const u=parseMediaCondition(i.value);return!1!==u?new MediaInParens(u,n,o):new MediaInParens(new GeneralEnclosed(i),e.slice(0,t).flatMap((e=>e.tokens())),e.slice(t+1).flatMap((e=>e.tokens())))}function parseMediaInParensFromSimpleBlock(e){if(e.startToken[0]!==r.TokenType.OpenParen)return!1;const t=parseMediaFeature(e,[e.startToken],[e.endToken]);if(!1!==t)return new MediaInParens(t);const i=parseMediaCondition(e.value);return!1!==i?new MediaInParens(i,[e.startToken],[e.endToken]):new MediaInParens(new GeneralEnclosed(e))}function parseMediaNot(e){let t=!1,i=null;for(let r=0;r<e.length;r++){const n=e[r];if(n.type!==a.ComponentValueType.Whitespace&&n.type!==a.ComponentValueType.Comment){if(isIdent(n)){if("not"===n.value[4].value.toLowerCase()){if(t)return!1;t=!0;continue}return!1}if(!t||!a.isSimpleBlockNode(n))return!1;{n.normalize();const t=parseMediaInParensFromSimpleBlock(n);if(!1===t)return!1;i=new MediaNot(e.slice(0,r).flatMap((e=>e.tokens())),t)}}}return i||!1}function parseMediaOr(e){let t=!1;for(let i=0;i<e.length;i++){const r=e[i];if(r.type!==a.ComponentValueType.Whitespace&&r.type!==a.ComponentValueType.Comment){if(isIdent(r)){if("or"===r.value[4].value.toLowerCase()){if(t)return!1;t=!0;continue}return!1}if(t&&a.isSimpleBlockNode(r)){r.normalize();const t=parseMediaInParensFromSimpleBlock(r);return!1!==t&&{advance:i,node:new MediaOr(e.slice(0,i).flatMap((e=>e.tokens())),t)}}return!1}}return!1}function parseMediaAnd(e){let t=!1;for(let i=0;i<e.length;i++){const r=e[i];if(r.type!==a.ComponentValueType.Whitespace&&r.type!==a.ComponentValueType.Comment){if(isIdent(r)){if("and"===r.value[4].value.toLowerCase()){if(t)return!1;t=!0;continue}return!1}if(t&&a.isSimpleBlockNode(r)){r.normalize();const t=parseMediaInParensFromSimpleBlock(r);return!1!==t&&{advance:i,node:new MediaAnd(e.slice(0,i).flatMap((e=>e.tokens())),t)}}return!1}}return!1}function parseFromTokens(e,t){const i=a.parseCommaSeparatedListOfComponentValues(e,{onParseError:null==t?void 0:t.onParseError});return i.map(((e,a)=>{const r=parseMediaQuery(e);return 0==r&&!0===(null==t?void 0:t.preserveInvalidMediaQueries)?new MediaQueryInvalid(i[a]):r})).filter((e=>!!e))}exports.MediaQueryModifier=void 0,(o=exports.MediaQueryModifier||(exports.MediaQueryModifier={})).Not="not",o.Only="only";class CustomMedia{type=exports.NodeType.CustomMedia;name;mediaQueryList=null;trueOrFalseKeyword=null;constructor(e,t,i){this.name=e,this.mediaQueryList=t,this.trueOrFalseKeyword=i}getName(){for(let e=0;e<this.name.length;e++){const t=this.name[e];if(t[0]===r.TokenType.Ident)return t[4].value}return""}getNameToken(){for(let e=0;e<this.name.length;e++){const t=this.name[e];if(t[0]===r.TokenType.Ident)return t}return null}hasMediaQueryList(){return!!this.mediaQueryList}hasTrueKeyword(){if(!this.trueOrFalseKeyword)return!1;for(let e=0;e<this.trueOrFalseKeyword.length;e++){const t=this.trueOrFalseKeyword[e];if(t[0]!==r.TokenType.Comment&&t[0]!==r.TokenType.Whitespace)return t[0]===r.TokenType.Ident&&"true"===t[4].value.toLowerCase()}return!1}hasFalseKeyword(){if(!this.trueOrFalseKeyword)return!1;for(let e=0;e<this.trueOrFalseKeyword.length;e++){const t=this.trueOrFalseKeyword[e];if(t[0]!==r.TokenType.Comment&&t[0]!==r.TokenType.Whitespace)return t[0]===r.TokenType.Ident&&"false"===t[4].value.toLowerCase()}return!1}tokens(){if(this.trueOrFalseKeyword)return[...this.name,...this.trueOrFalseKeyword];const e=[];for(let t=0;t<this.mediaQueryList.length;t++){const i=this.mediaQueryList[t];0!==t&&e.push([r.TokenType.Comma,",",-1,-1,void 0]),e.push(...i.tokens())}return[...this.name,...e]}toString(){return r.stringify(...this.tokens())}toJSON(){var e;return{type:this.type,string:this.toString(),nameValue:this.getName(),name:this.name,hasFalseKeyword:this.hasFalseKeyword(),hasTrueKeyword:this.hasTrueKeyword(),trueOrFalseKeyword:this.trueOrFalseKeyword,mediaQueryList:null==(e=this.mediaQueryList)?void 0:e.map((e=>e.toJSON()))}}isCustomMedia(){return CustomMedia.isCustomMedia(this)}static isCustomMedia(e){return!!e&&(e instanceof CustomMedia&&e.type===exports.NodeType.CustomMedia)}}function parseCustomMediaFromTokens(e,t){let i=[],a=e;for(let t=0;t<e.length;t++)if(e[t][0]!==r.TokenType.Comment&&e[t][0]!==r.TokenType.Whitespace){if(e[t][0]===r.TokenType.Ident){if(e[t][4].value.startsWith("--")){i=e.slice(0,t+1),a=e.slice(t+1);break}}return!1}let n=!0;for(let e=0;e<a.length;e++)if(a[e][0]!==r.TokenType.Comment&&a[e][0]!==r.TokenType.Whitespace){if(a[e][0]===r.TokenType.Ident){const t=a[e][4].value.toLowerCase();if("false"===t)continue;if("true"===t)continue}if(a[e][0]===r.TokenType.EOF)break;n=!1}return n?new CustomMedia(i,null,a):new CustomMedia(i,parseFromTokens(r.cloneTokens(a),t))}function isMediaConditionListWithAnd(e){return MediaConditionListWithAnd.isMediaConditionListWithAnd(e)}function isMediaConditionListWithOr(e){return MediaConditionListWithOr.isMediaConditionListWithOr(e)}function isMediaFeatureRangeNameValue(e){return MediaFeatureRangeNameValue.isMediaFeatureRangeNameValue(e)}function isMediaFeatureRangeValueName(e){return MediaFeatureRangeValueName.isMediaFeatureRangeValueName(e)}function isMediaFeatureRangeValueNameValue(e){return MediaFeatureRangeValueNameValue.isMediaFeatureRangeValueNameValue(e)}function isMediaQueryWithType(e){return MediaQueryWithType.isMediaQueryWithType(e)}function isMediaQueryWithoutType(e){return MediaQueryWithoutType.isMediaQueryWithoutType(e)}function isMediaQueryInvalid(e){return MediaQueryInvalid.isMediaQueryInvalid(e)}exports.MediaType=void 0,(s=exports.MediaType||(exports.MediaType={})).All="all",s.Print="print",s.Screen="screen",s.Tty="tty",s.Tv="tv",s.Projection="projection",s.Handheld="handheld",s.Braille="braille",s.Embossed="embossed",s.Aural="aural",s.Speech="speech",exports.CustomMedia=CustomMedia,exports.GeneralEnclosed=GeneralEnclosed,exports.MediaAnd=MediaAnd,exports.MediaCondition=MediaCondition,exports.MediaConditionListWithAnd=MediaConditionListWithAnd,exports.MediaConditionListWithOr=MediaConditionListWithOr,exports.MediaFeature=MediaFeature,exports.MediaFeatureBoolean=MediaFeatureBoolean,exports.MediaFeatureName=MediaFeatureName,exports.MediaFeaturePlain=MediaFeaturePlain,exports.MediaFeatureRangeNameValue=MediaFeatureRangeNameValue,exports.MediaFeatureRangeValueName=MediaFeatureRangeValueName,exports.MediaFeatureRangeValueNameValue=MediaFeatureRangeValueNameValue,exports.MediaFeatureValue=MediaFeatureValue,exports.MediaInParens=MediaInParens,exports.MediaNot=MediaNot,exports.MediaOr=MediaOr,exports.MediaQueryInvalid=MediaQueryInvalid,exports.MediaQueryWithType=MediaQueryWithType,exports.MediaQueryWithoutType=MediaQueryWithoutType,exports.cloneMediaQuery=function cloneMediaQuery(e){const t=r.cloneTokens(e.tokens()),i=parseFromTokens(t,{preserveInvalidMediaQueries:!0})[0];if(!i)throw new Error(`Failed to clone media query for : "${r.stringify(...t)}"`);if(isMediaQueryInvalid(e)&&isMediaQueryInvalid(i))return i;if(isMediaQueryWithType(e)&&isMediaQueryWithType(i))return i;if(isMediaQueryWithoutType(e)&&isMediaQueryWithoutType(i))return i;throw new Error(`Failed to clone media query for : "${r.stringify(...t)}"`)},exports.comparisonFromTokens=comparisonFromTokens,exports.invertComparison=function invertComparison(e){switch(e){case exports.MediaFeatureEQ.EQ:return exports.MediaFeatureEQ.EQ;case exports.MediaFeatureLT.LT:return exports.MediaFeatureGT.GT;case exports.MediaFeatureLT.LT_OR_EQ:return exports.MediaFeatureGT.GT_OR_EQ;case exports.MediaFeatureGT.GT:return exports.MediaFeatureLT.LT;case exports.MediaFeatureGT.GT_OR_EQ:return exports.MediaFeatureLT.LT_OR_EQ;default:return!1}},exports.isCustomMedia=function isCustomMedia(e){return CustomMedia.isCustomMedia(e)},exports.isGeneralEnclosed=function isGeneralEnclosed(e){return GeneralEnclosed.isGeneralEnclosed(e)},exports.isMediaAnd=function isMediaAnd(e){return MediaAnd.isMediaAnd(e)},exports.isMediaCondition=function isMediaCondition(e){return MediaCondition.isMediaCondition(e)},exports.isMediaConditionList=function isMediaConditionList(e){return isMediaConditionListWithAnd(e)||isMediaConditionListWithOr(e)},exports.isMediaConditionListWithAnd=isMediaConditionListWithAnd,exports.isMediaConditionListWithOr=isMediaConditionListWithOr,exports.isMediaFeature=function isMediaFeature(e){return MediaFeature.isMediaFeature(e)},exports.isMediaFeatureBoolean=function isMediaFeatureBoolean(e){return MediaFeatureBoolean.isMediaFeatureBoolean(e)},exports.isMediaFeatureName=function isMediaFeatureName(e){return MediaFeatureName.isMediaFeatureName(e)},exports.isMediaFeaturePlain=function isMediaFeaturePlain(e){return MediaFeaturePlain.isMediaFeaturePlain(e)},exports.isMediaFeatureRange=function isMediaFeatureRange(e){return isMediaFeatureRangeNameValue(e)||isMediaFeatureRangeValueName(e)||isMediaFeatureRangeValueNameValue(e)},exports.isMediaFeatureRangeNameValue=isMediaFeatureRangeNameValue,exports.isMediaFeatureRangeValueName=isMediaFeatureRangeValueName,exports.isMediaFeatureRangeValueNameValue=isMediaFeatureRangeValueNameValue,exports.isMediaFeatureValue=function isMediaFeatureValue(e){return MediaFeatureValue.isMediaFeatureValue(e)},exports.isMediaInParens=function isMediaInParens(e){return MediaInParens.isMediaInParens(e)},exports.isMediaNot=function isMediaNot(e){return MediaNot.isMediaNot(e)},exports.isMediaOr=function isMediaOr(e){return MediaOr.isMediaOr(e)},exports.isMediaQuery=function isMediaQuery(e){return isMediaQueryWithType(e)||isMediaQueryWithoutType(e)||isMediaQueryInvalid(e)},exports.isMediaQueryInvalid=isMediaQueryInvalid,exports.isMediaQueryWithType=isMediaQueryWithType,exports.isMediaQueryWithoutType=isMediaQueryWithoutType,exports.matchesComparison=matchesComparison,exports.matchesRatio=matchesRatio,exports.matchesRatioExactly=matchesRatioExactly,exports.modifierFromToken=modifierFromToken,exports.newMediaFeatureBoolean=function newMediaFeatureBoolean(e){const t=[r.TokenType.Ident,"",-1,-1,{value:""}];return r.mutateIdent(t,e),new MediaFeature(new MediaFeatureBoolean(new MediaFeatureName(new a.TokenNode(t))),[[r.TokenType.OpenParen,"(",-1,-1,void 0]],[[r.TokenType.CloseParen,")",-1,-1,void 0]])},exports.newMediaFeaturePlain=function newMediaFeaturePlain(e,...t){const i=[r.TokenType.Ident,"",-1,-1,{value:""}];r.mutateIdent(i,e);const n=a.parseListOfComponentValues(t);return new MediaFeature(new MediaFeaturePlain(new MediaFeatureName(new a.TokenNode(i)),[r.TokenType.Colon,":",-1,-1,void 0],new MediaFeatureValue(1===n.length?n[0]:n)),[[r.TokenType.OpenParen,"(",-1,-1,void 0]],[[r.TokenType.CloseParen,")",-1,-1,void 0]])},exports.parse=function parse(e,t){const i=r.tokenizer({css:e},{onParseError:null==t?void 0:t.onParseError}),a=[];for(;!i.endOfFile();)a.push(i.nextToken());return a.push(i.nextToken()),parseFromTokens(a,t)},exports.parseCustomMedia=function parseCustomMedia(e,t){const i=r.tokenizer({css:e},{onParseError:null==t?void 0:t.onParseError}),a=[];for(;!i.endOfFile();)a.push(i.nextToken());return a.push(i.nextToken()),parseCustomMediaFromTokens(a,t)},exports.parseCustomMediaFromTokens=parseCustomMediaFromTokens,exports.parseFromTokens=parseFromTokens,exports.typeFromToken=function typeFromToken(e){if(e[0]!==r.TokenType.Ident)return!1;switch(e[4].value.toLowerCase()){case exports.MediaType.All:return exports.MediaType.All;case exports.MediaType.Print:return exports.MediaType.Print;case exports.MediaType.Screen:return exports.MediaType.Screen;case exports.MediaType.Tty:return exports.MediaType.Tty;case exports.MediaType.Tv:return exports.MediaType.Tv;case exports.MediaType.Projection:return exports.MediaType.Projection;case exports.MediaType.Handheld:return exports.MediaType.Handheld;case exports.MediaType.Braille:return exports.MediaType.Braille;case exports.MediaType.Embossed:return exports.MediaType.Embossed;case exports.MediaType.Aural:return exports.MediaType.Aural;case exports.MediaType.Speech:return exports.MediaType.Speech;default:return!1}};
