/*!
 * @nuxt/cli v2.16.0 (c) 2016-2023
 * Released under the MIT License
 * Repository: https://github.com/nuxt/nuxt.js
 * Website: https://nuxtjs.org
*/
'use strict';

const consola = require('consola');
const index = require('./cli-index.js');
const chalk = require('chalk');
require('@nuxt/utils');
require('@nuxt/config');
require('path');
require('exit');
require('std-env');
require('wrap-ansi');
require('boxen');
require('minimist');
require('hable');
require('defu');
require('semver');
require('fs');
require('execa');

async function listCommands() {
  const commandsOrder = ["dev", "build", "generate", "start", "help"];
  const _commands = await Promise.all(
    commandsOrder.map((cmd) => index.getCommand(cmd))
  );
  let maxLength = 0;
  const commandsHelp = [];
  for (const command of _commands) {
    commandsHelp.push([command.usage, command.description]);
    maxLength = Math.max(maxLength, command.usage.length);
  }
  const _cmds = commandsHelp.map(([cmd, description]) => {
    const i = index.indent(maxLength + index.optionSpaces - cmd.length);
    return index.foldLines(
      chalk.green(cmd) + i + description,
      index.startSpaces + maxLength + index.optionSpaces * 2,
      index.startSpaces + index.optionSpaces
    );
  }).join("\n");
  const usage = index.foldLines("Usage: nuxt <command> [--help|-h]", index.startSpaces);
  const cmds = index.foldLines("Commands:", index.startSpaces) + "\n\n" + _cmds;
  process.stderr.write(index.colorize(`${usage}

${cmds}

`));
}

const help = {
  name: "help",
  description: "Shows help for <command>",
  usage: "help <command>",
  options: {
    help: index.common.help,
    version: index.common.version
  },
  async run(cmd) {
    const [name] = cmd._argv;
    if (!name) {
      return listCommands();
    }
    const command = await index.getCommand(name);
    if (!command) {
      consola.info(`Unknown command: ${name}`);
      return;
    }
    index.NuxtCommand.from(command).showHelp();
  }
};

exports.default = help;
