export default {
  addEventListeners(el, events, handler) {
    for (var i = 0, len = events.length; i < len; i++) {
      el.addEventListener(events[i], handler)
    }
  },

  removeEventListeners(el, events, handler) {
    for (var i = 0, len = events.length; i < len; i++) {
      el.removeEventListener(events[i], handler)
    }
  },

  getPointer(evt) {
    let pointer
    if (evt.touches && evt.touches[0]) {
      pointer = evt.touches[0]
    } else if (evt.changedTouches && evt.changedTouches[0]) {
      pointer = evt.changedTouches[0]
    } else {
      pointer = evt
    }
    return pointer
  }
}
