import Vue from 'vue'
import Router from 'vue-router'
import { normalizeURL, decode } from 'ufo'
import { interopDefault } from './utils'
import scrollBehavior from './router.scrollBehavior.js'

const _5f706b43 = () => interopDefault(import('..\\pages\\brands.vue' /* webpackChunkName: "pages/brands" */))
const _51e8bb52 = () => interopDefault(import('..\\pages\\cart.vue' /* webpackChunkName: "pages/cart" */))
const _6c8b47da = () => interopDefault(import('..\\pages\\categories.vue' /* webpackChunkName: "pages/categories" */))
const _6a7589fd = () => interopDefault(import('..\\pages\\checkout.vue' /* webpackChunkName: "pages/checkout" */))
const _791cea27 = () => interopDefault(import('..\\pages\\flash-sale\\index.vue' /* webpackChunkName: "pages/flash-sale/index" */))
const _9d1ce7c4 = () => interopDefault(import('..\\pages\\forgot-password.vue' /* webpackChunkName: "pages/forgot-password" */))
const _cc47567c = () => interopDefault(import('..\\pages\\login.vue' /* webpackChunkName: "pages/login" */))
const _5c94a31e = () => interopDefault(import('..\\pages\\razorpay-callback.vue' /* webpackChunkName: "pages/razorpay-callback" */))
const _a507164c = () => interopDefault(import('..\\pages\\register.vue' /* webpackChunkName: "pages/register" */))
const _3bbf45c2 = () => interopDefault(import('..\\pages\\search.vue' /* webpackChunkName: "pages/search" */))
const _08f2b336 = () => interopDefault(import('..\\pages\\shipping.vue' /* webpackChunkName: "pages/shipping" */))
const _dfa4be84 = () => interopDefault(import('..\\pages\\social-callback.vue' /* webpackChunkName: "pages/social-callback" */))
const _c955a136 = () => interopDefault(import('..\\pages\\track-order.vue' /* webpackChunkName: "pages/track-order" */))
const _74ee0890 = () => interopDefault(import('..\\pages\\user\\addresses.vue' /* webpackChunkName: "pages/user/addresses" */))
const _e19aa5be = () => interopDefault(import('..\\pages\\user\\compared.vue' /* webpackChunkName: "pages/user/compared" */))
const _711d2002 = () => interopDefault(import('..\\pages\\user\\following.vue' /* webpackChunkName: "pages/user/following" */))
const _72224f67 = () => interopDefault(import('..\\pages\\user\\orders.vue' /* webpackChunkName: "pages/user/orders" */))
const _48ba9897 = () => interopDefault(import('..\\pages\\user\\profile.vue' /* webpackChunkName: "pages/user/profile" */))
const _7aad7187 = () => interopDefault(import('..\\pages\\user\\vouchers.vue' /* webpackChunkName: "pages/user/vouchers" */))
const _61dcda3c = () => interopDefault(import('..\\pages\\user\\wishlists.vue' /* webpackChunkName: "pages/user/wishlists" */))
const _733d7bae = () => interopDefault(import('..\\pages\\user\\order\\_id.vue' /* webpackChunkName: "pages/user/order/_id" */))
const _57527fe2 = () => interopDefault(import('..\\pages\\all\\_category\\index.vue' /* webpackChunkName: "pages/all/_category/index" */))
const _a9456b62 = () => interopDefault(import('..\\pages\\flash-sale\\_id.vue' /* webpackChunkName: "pages/flash-sale/_id" */))
const _3f930398 = () => interopDefault(import('..\\pages\\page\\_slug.vue' /* webpackChunkName: "pages/page/_slug" */))
const _38d8e126 = () => interopDefault(import('..\\pages\\shop\\_slug.vue' /* webpackChunkName: "pages/shop/_slug" */))
const _4a577772 = () => interopDefault(import('..\\pages\\all\\_category\\_subCategory.vue' /* webpackChunkName: "pages/all/_category/_subCategory" */))
const _5f969caa = () => interopDefault(import('..\\pages\\index.vue' /* webpackChunkName: "pages/index" */))
const _453dae9c = () => interopDefault(import('..\\pages\\_main\\brand\\index.vue' /* webpackChunkName: "pages/_main/brand/index" */))
const _9e1ab8da = () => interopDefault(import('..\\pages\\_main\\collection\\index.vue' /* webpackChunkName: "pages/_main/collection/index" */))
const _7f4dfecd = () => interopDefault(import('..\\pages\\_main\\products\\index.vue' /* webpackChunkName: "pages/_main/products/index" */))
const _4815a95c = () => interopDefault(import('..\\pages\\_main\\product\\_id.vue' /* webpackChunkName: "pages/_main/product/_id" */))

const emptyFn = () => {}

Vue.use(Router)

export const routerOptions = {
  mode: 'history',
  base: '/',
  linkActiveClass: 'nuxt-link-active',
  linkExactActiveClass: 'nuxt-link-exact-active',
  scrollBehavior,

  routes: [{
    path: "/brands",
    component: _5f706b43,
    name: "brands___en"
  }, {
    path: "/cart",
    component: _51e8bb52,
    name: "cart___en"
  }, {
    path: "/categories",
    component: _6c8b47da,
    name: "categories___en"
  }, {
    path: "/checkout",
    component: _6a7589fd,
    name: "checkout___en"
  }, {
    path: "/flash-sale",
    component: _791cea27,
    name: "flash-sale___en"
  }, {
    path: "/forgot-password",
    component: _9d1ce7c4,
    name: "forgot-password___en"
  }, {
    path: "/login",
    component: _cc47567c,
    name: "login___en"
  }, {
    path: "/razorpay-callback",
    component: _5c94a31e,
    name: "razorpay-callback___en"
  }, {
    path: "/register",
    component: _a507164c,
    name: "register___en"
  }, {
    path: "/search",
    component: _3bbf45c2,
    name: "search___en"
  }, {
    path: "/shipping",
    component: _08f2b336,
    name: "shipping___en"
  }, {
    path: "/social-callback",
    component: _dfa4be84,
    name: "social-callback___en"
  }, {
    path: "/track-order",
    component: _c955a136,
    name: "track-order___en"
  }, {
    path: "/user/addresses",
    component: _74ee0890,
    name: "user-addresses___en"
  }, {
    path: "/user/compared",
    component: _e19aa5be,
    name: "user-compared___en"
  }, {
    path: "/user/following",
    component: _711d2002,
    name: "user-following___en"
  }, {
    path: "/user/orders",
    component: _72224f67,
    name: "user-orders___en"
  }, {
    path: "/user/profile",
    component: _48ba9897,
    name: "user-profile___en"
  }, {
    path: "/user/vouchers",
    component: _7aad7187,
    name: "user-vouchers___en"
  }, {
    path: "/user/wishlists",
    component: _61dcda3c,
    name: "user-wishlists___en"
  }, {
    path: "/user/order/:id?",
    component: _733d7bae,
    name: "user-order-id___en"
  }, {
    path: "/all/:category",
    component: _57527fe2,
    name: "all-category___en"
  }, {
    path: "/flash-sale/:id?",
    component: _a9456b62,
    name: "flash-sale-id___en"
  }, {
    path: "/page/:slug?",
    component: _3f930398,
    name: "page-slug___en"
  }, {
    path: "/shop/:slug?",
    component: _38d8e126,
    name: "shop-slug___en"
  }, {
    path: "/all/:category?/:subCategory",
    component: _4a577772,
    name: "all-category-subCategory___en"
  }, {
    path: "/",
    component: _5f969caa,
    name: "index___en"
  }, {
    path: "/:main/brand",
    component: _453dae9c,
    name: "main-brand___en"
  }, {
    path: "/:main/collection",
    component: _9e1ab8da,
    name: "main-collection___en"
  }, {
    path: "/:main/products",
    component: _7f4dfecd,
    name: "main-products___en"
  }, {
    path: "/:main/product/:id?",
    component: _4815a95c,
    name: "main-product-id___en"
  }],

  fallback: false
}

export function createRouter (ssrContext, config) {
  const base = (config._app && config._app.basePath) || routerOptions.base
  const router = new Router({ ...routerOptions, base  })

  // TODO: remove in Nuxt 3
  const originalPush = router.push
  router.push = function push (location, onComplete = emptyFn, onAbort) {
    return originalPush.call(this, location, onComplete, onAbort)
  }

  const resolve = router.resolve.bind(router)
  router.resolve = (to, current, append) => {
    if (typeof to === 'string') {
      to = normalizeURL(to)
    }
    return resolve(to, current, append)
  }

  return router
}
