import u from './util'

const POINTER_START_EVENTS = ['mousedown', 'touchstart']
const POINTER_MOVE_EVENTS = ['mousemove', 'touchmove']
const POINTER_END_EVENTS = ['mouseup', 'touchend']
var draggedElem

export default {
  inserted(el, binding, vnode) {
    if (!document) return
    var prevent = !!binding.modifiers.prevent
    function onPointerStart(evt) {
      prevent && evt.preventDefault()
      var pointer = u.getPointer(evt)
      el.lastCoords = el.firstCoords = {
        x: pointer.clientX,
        y: pointer.clientY
      }
      binding.value({
        el,
        first: true,
        clientX: pointer.clientX,
        clientY: pointer.clientY
      })
      draggedElem = el
    }
    function onPointerEnd(evt) {
      prevent && evt.preventDefault()
      if (el !== draggedElem) return
      el.lastCoords = null
      var pointer = u.getPointer(evt)
      binding.value({
        el,
        last: true,
        clientX: pointer.clientX,
        clientY: pointer.clientY
      })
      draggedElem = null
    }
    function onPointerMove(evt) {
      prevent && evt.preventDefault()
      if (el !== draggedElem) return
      var pointer = u.getPointer(evt)
      if (el.lastCoords) {
        var deltaX = pointer.clientX - el.lastCoords.x
        var deltaY = pointer.clientY - el.lastCoords.y
        var offsetX = pointer.clientX - el.firstCoords.x
        var offsetY = pointer.clientY - el.firstCoords.y
        var clientX = pointer.clientX
        var clientY = pointer.clientY

        binding.value({
          el,
          deltaX,
          deltaY,
          offsetX,
          offsetY,
          clientX,
          clientY
        })
        el.lastCoords = {
          x: pointer.clientX,
          y: pointer.clientY
        }
      }
    }
    u.addEventListeners(el, POINTER_START_EVENTS, onPointerStart)
    u.addEventListeners(
      document.documentElement,
      POINTER_END_EVENTS,
      onPointerEnd
    )
    u.addEventListeners(
      document.documentElement,
      POINTER_MOVE_EVENTS,
      onPointerMove
    )
  },

  unbind(el) {
    u.removeEventListeners(el, POINTER_START_EVENTS)
    u.removeEventListeners(document.documentElement, POINTER_END_EVENTS)
    u.removeEventListeners(document.documentElement, POINTER_MOVE_EVENTS)
  }
}
